<?php
/**
 *
 * @package 
 * @author     Ole Jungclaussen
 * @version    0.9.1
 * @.copyright 2021-23, Ole Jungclaussen
 */
require_once('./ServerlistBySteam.inc.php');
require_once('./Server.inc.php');
// ################################################
function exception_error_handler($errno, $errstr, $errfile, $errline ) {
    throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
}
set_error_handler("exception_error_handler");
/**
 * 
 * @package 
 */
class PrintDiag {
    /**
     * 
     * @param mixed $m 
     * @return void 
     */
    static function print($m)
    {
        print '<pre>';
        if(is_array($m))
        {
            print_r($m);
        }
        else
        {
            print $m;
        }
        print '</pre>';
    }
}
// ################################################
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>clod-server-list php-v8.x</title>
</head>
<body>
<?php
$sCfgFile = __DIR__.'/config.ini';
$ServerListBySteam = new CServerlistBySteam();
// $ServerListBySteam->setDiagnosticLog(array( 'PrintDiag', 'print' ));

if(!is_file($sCfgFile))
{
    die('no configuration file found!');
}
$aCfg = parse_ini_file($sCfgFile, true, INI_SCANNER_NORMAL);

$ServerListBySteam->load($aCfg['steam']['api_key'], $aCfg['steam']['app_id']);

print '<pre>';
foreach($ServerListBySteam->aServers as $ServerBySteam)
{
    print '<hr><hr>';
    print 'Retrieve: '.$ServerBySteam->sIp.':'.$ServerBySteam->sPort;
    $Server = new CClodServer($ServerBySteam->sIp, $ServerBySteam->sPort);
    // $Server->setDiagnosticLog(array( 'PrintDiag', 'print' ));

    if($Server->queryInfo())
    {
        print '<h2>'.$Server->sHostName.'</h2>'.PHP_EOL;
        print 'Map: '.$Server->aRawInfo['Map'].PHP_EOL;
        print strval($Server->nPlayers).' players'.PHP_EOL;
    }
}
print '</pre>';
?>
</body>
</html>