<?php
/**
 *
 *
 * @package 
 * @author     Ole Jungclaussen
 * @version    0.9.1
 * @.copyright 2021-23, Ole Jungclaussen
 */
require_once('PHP-Source-Query-2.1.0/SourceQuery.php');
require_once('PHP-Source-Query-2.1.0/BaseSocket.php');
require_once('PHP-Source-Query-2.1.0/bootstrap.php');
require_once('PHP-Source-Query-2.1.0/Buffer.php');
require_once('PHP-Source-Query-2.1.0/GoldSourceRcon.php');
require_once('PHP-Source-Query-2.1.0/Socket.php');
require_once('PHP-Source-Query-2.1.0/SourceQuery.php');
require_once('PHP-Source-Query-2.1.0/SourceRcon.php');
/**
 * A Server running Cliffs Of Dover
 */
class CClodServer {
// ########## PUBLIC PROPERTIES
    /**
     * 
     * @var string
     */
    public ?string $sIp   = null;
    /**
     * 
     * @var string
     */
    public ?string $sPort = null;
    /**
     *  [Protocol] => 17 
     *  [HostName] => DangerDogz - All Welcome! 
     *  [Map] => English_Channel_1940 
     *  [ModDir] => cliffsofdover 
     *  [ModDesc] => Cliffs of Dover 
     *  [AppID] => 0 
     *  [Players] => 1 
     *  [MaxPlayers] => 44 
     *  [Bots] => 0 
     *  [Dedicated] => d 
     *  [Os] => w 
     *  [Password] => 
     *  [Secure] => 1 
     *  [Version] => 4.5.3.0 
     *  [ExtraDataFlags] => 177 
     *  [GamePort] => 27016 
     *  [ServerID] => 127902730 
     *  [GameTags] => $(defaultRV?k$!!!!!"Mg00+ 
     *  [GameID] => 754530 
     *  @var array
     */
    public array $aRawInfo = [];
    /**
     * Server's name.
     * @var string
     */
    public ?string $sHostName = null;
    /**
     * Players on Server.
     * @var array
     */
    public array $aPlayers = [];
    /**
     * Number of Players on Server.
     * @var int
     */
    public int $nPlayers = 0;
// ########## PROTECTED PROPERTIES
    /**
     * 
     * @var null|array
     */
    protected ?array $fnLog = null;
    /**
     * 
     * @var bool
     */
    protected bool $bLogDiagnostics = false;
// ########## PRIVATE PROPERTIES
// ########## CONSTRUCTOR
    /**
     * 
     * @param string $sIp 
     * @param string $sPort 
     * @return void 
     */
    function __construct(string $sIp, string $sPort)
    {
        $this->sIp   = $sIp;
        $this->sPort = $sPort;
    }
    /**
     *
     *
     */
    function __destruct()
    {
        
    }
// ########## METHOD PUBLIC
    /**
     * 
     * @param array $fnLog call_user_func($fnLog, "text to log") 
     * @return void 
     */
    public function setDiagnosticLog(array $fnLog)
    {
        $this->fnLog = $fnLog;
        $this->bLogDiagnostics = true;
    }
    /**
     * 
     * @return bool 
     */
    public function queryInfo() : bool
    {
        if($this->bLogDiagnostics)
        {
            call_user_func($this->fnLog, 'Querying '.$this->sIp.':'.$this->sPort);
        }

        try {
            $Query = new xPaw\SourceQuery\SourceQuery();
            $Query->Connect($this->sIp, $this->sPort, 1, xPaw\SourceQuery\SourceQuery :: SOURCE );
            $this->aRawInfo = $Query->GetInfo();
            if($this->bLogDiagnostics)
            {
                call_user_func($this->fnLog, $this->aRawInfo);
            }
        }
        catch(Exception $e)
        {
            if($this->bLogDiagnostics)
            {
                call_user_func($this->fnLog, 'QUERY FAILURE['.$e->getMessage().']');
            }
            return false;
        }
        
        $this->sHostName = trim($this->aRawInfo['HostName']);
        if(empty($this->sHostName)) $this->sHostName = 'unknown';
        
        if(true==$this->bLogDiagnostics)
        {
            call_user_func($this->fnLog, '    Hostname: '.$this->sHostName);
        }
        
        $this->aPlayers = array();
        $this->nPlayers = 0;
        
        $aTmpPlayers = $Query->GetPlayers();
        
        if(true==$this->bLogDiagnostics)
        {
            call_user_func($this->fnLog, '    Players : '.strval(count($aTmpPlayers)));
        }
        
        if(is_array($aTmpPlayers))
        {
            foreach($aTmpPlayers as $aPlayer)
            {
                $sName = trim($aPlayer['Name']);
                if(empty($sName)) $sName = 'empty_string_user';
                $this->aPlayers[] = $sName;
                $this->nPlayers++;
                if(true==$this->bLogDiagnostics)
                {
                    call_user_func($this->fnLog, '              * '.$sName);
                }
            }
        }

        return true;
    }
// ########## METHOD PROTECTED
// ########## METHOD PRIVATE
};